# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DashboardArgs', 'Dashboard']

@pulumi.input_type
class DashboardArgs:
    def __init__(__self__, *,
                 panels: pulumi.Input[Sequence[pulumi.Input['DashboardPanelArgs']]],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 public: Optional[pulumi.Input[bool]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardScopeArgs']]]] = None):
        """
        The set of arguments for constructing a Dashboard resource.
        :param pulumi.Input[Sequence[pulumi.Input['DashboardPanelArgs']]] panels: At least 1 panel is required to define a Dashboard.
        :param pulumi.Input[str] description: Description of the panel.
        :param pulumi.Input[str] name: Name of the panel.
        :param pulumi.Input[bool] public: Define if the dashboard can be accessible without requiring the user to be logged in.
        :param pulumi.Input[Sequence[pulumi.Input['DashboardScopeArgs']]] scopes: Define the scope of the dashboard and variables for these metrics.
        """
        pulumi.set(__self__, "panels", panels)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public is not None:
            pulumi.set(__self__, "public", public)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter
    def panels(self) -> pulumi.Input[Sequence[pulumi.Input['DashboardPanelArgs']]]:
        """
        At least 1 panel is required to define a Dashboard.
        """
        return pulumi.get(self, "panels")

    @panels.setter
    def panels(self, value: pulumi.Input[Sequence[pulumi.Input['DashboardPanelArgs']]]):
        pulumi.set(self, "panels", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the panel.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the panel.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def public(self) -> Optional[pulumi.Input[bool]]:
        """
        Define if the dashboard can be accessible without requiring the user to be logged in.
        """
        return pulumi.get(self, "public")

    @public.setter
    def public(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "public", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardScopeArgs']]]]:
        """
        Define the scope of the dashboard and variables for these metrics.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardScopeArgs']]]]):
        pulumi.set(self, "scopes", value)


@pulumi.input_type
class _DashboardState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 panels: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardPanelArgs']]]] = None,
                 public: Optional[pulumi.Input[bool]] = None,
                 public_token: Optional[pulumi.Input[str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardScopeArgs']]]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Dashboard resources.
        :param pulumi.Input[str] description: Description of the panel.
        :param pulumi.Input[str] name: Name of the panel.
        :param pulumi.Input[Sequence[pulumi.Input['DashboardPanelArgs']]] panels: At least 1 panel is required to define a Dashboard.
        :param pulumi.Input[bool] public: Define if the dashboard can be accessible without requiring the user to be logged in.
        :param pulumi.Input[str] public_token: (Computed) Token defined when the dashboard is set Public.
        :param pulumi.Input[Sequence[pulumi.Input['DashboardScopeArgs']]] scopes: Define the scope of the dashboard and variables for these metrics.
        :param pulumi.Input[int] version: (Computed)  The current version of the Dashboard.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if panels is not None:
            pulumi.set(__self__, "panels", panels)
        if public is not None:
            pulumi.set(__self__, "public", public)
        if public_token is not None:
            pulumi.set(__self__, "public_token", public_token)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the panel.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the panel.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def panels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardPanelArgs']]]]:
        """
        At least 1 panel is required to define a Dashboard.
        """
        return pulumi.get(self, "panels")

    @panels.setter
    def panels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardPanelArgs']]]]):
        pulumi.set(self, "panels", value)

    @property
    @pulumi.getter
    def public(self) -> Optional[pulumi.Input[bool]]:
        """
        Define if the dashboard can be accessible without requiring the user to be logged in.
        """
        return pulumi.get(self, "public")

    @public.setter
    def public(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "public", value)

    @property
    @pulumi.getter(name="publicToken")
    def public_token(self) -> Optional[pulumi.Input[str]]:
        """
        (Computed) Token defined when the dashboard is set Public.
        """
        return pulumi.get(self, "public_token")

    @public_token.setter
    def public_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_token", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DashboardScopeArgs']]]]:
        """
        Define the scope of the dashboard and variables for these metrics.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DashboardScopeArgs']]]]):
        pulumi.set(self, "scopes", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        (Computed)  The current version of the Dashboard.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class Dashboard(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 panels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardPanelArgs']]]]] = None,
                 public: Optional[pulumi.Input[bool]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardScopeArgs']]]]] = None,
                 __props__=None):
        """
        ## Import

        Monitor dashboards can be imported using the dashboard ID, e.g.

        ```sh
         $ pulumi import sysdig:Monitor/dashboard:Dashboard example 12345
        ```

         Only dashboards that contain supported panels can be imported. Currently supported panel types are- PromQL timecharts - PromQL numbers - Text Only dashboards that contain supported query types can be imported. Currently supported query types- Percent - Data - Data rate - Number - Number rate - Time

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the panel.
        :param pulumi.Input[str] name: Name of the panel.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardPanelArgs']]]] panels: At least 1 panel is required to define a Dashboard.
        :param pulumi.Input[bool] public: Define if the dashboard can be accessible without requiring the user to be logged in.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardScopeArgs']]]] scopes: Define the scope of the dashboard and variables for these metrics.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DashboardArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Monitor dashboards can be imported using the dashboard ID, e.g.

        ```sh
         $ pulumi import sysdig:Monitor/dashboard:Dashboard example 12345
        ```

         Only dashboards that contain supported panels can be imported. Currently supported panel types are- PromQL timecharts - PromQL numbers - Text Only dashboards that contain supported query types can be imported. Currently supported query types- Percent - Data - Data rate - Number - Number rate - Time

        :param str resource_name: The name of the resource.
        :param DashboardArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DashboardArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 panels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardPanelArgs']]]]] = None,
                 public: Optional[pulumi.Input[bool]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardScopeArgs']]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DashboardArgs.__new__(DashboardArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if panels is None and not opts.urn:
                raise TypeError("Missing required property 'panels'")
            __props__.__dict__["panels"] = panels
            __props__.__dict__["public"] = public
            __props__.__dict__["scopes"] = scopes
            __props__.__dict__["public_token"] = None
            __props__.__dict__["version"] = None
        super(Dashboard, __self__).__init__(
            'sysdig:Monitor/dashboard:Dashboard',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            panels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardPanelArgs']]]]] = None,
            public: Optional[pulumi.Input[bool]] = None,
            public_token: Optional[pulumi.Input[str]] = None,
            scopes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardScopeArgs']]]]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'Dashboard':
        """
        Get an existing Dashboard resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the panel.
        :param pulumi.Input[str] name: Name of the panel.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardPanelArgs']]]] panels: At least 1 panel is required to define a Dashboard.
        :param pulumi.Input[bool] public: Define if the dashboard can be accessible without requiring the user to be logged in.
        :param pulumi.Input[str] public_token: (Computed) Token defined when the dashboard is set Public.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardScopeArgs']]]] scopes: Define the scope of the dashboard and variables for these metrics.
        :param pulumi.Input[int] version: (Computed)  The current version of the Dashboard.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DashboardState.__new__(_DashboardState)

        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["panels"] = panels
        __props__.__dict__["public"] = public
        __props__.__dict__["public_token"] = public_token
        __props__.__dict__["scopes"] = scopes
        __props__.__dict__["version"] = version
        return Dashboard(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the panel.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the panel.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def panels(self) -> pulumi.Output[Sequence['outputs.DashboardPanel']]:
        """
        At least 1 panel is required to define a Dashboard.
        """
        return pulumi.get(self, "panels")

    @property
    @pulumi.getter
    def public(self) -> pulumi.Output[Optional[bool]]:
        """
        Define if the dashboard can be accessible without requiring the user to be logged in.
        """
        return pulumi.get(self, "public")

    @property
    @pulumi.getter(name="publicToken")
    def public_token(self) -> pulumi.Output[str]:
        """
        (Computed) Token defined when the dashboard is set Public.
        """
        return pulumi.get(self, "public_token")

    @property
    @pulumi.getter
    def scopes(self) -> pulumi.Output[Optional[Sequence['outputs.DashboardScope']]]:
        """
        Define the scope of the dashboard and variables for these metrics.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        """
        (Computed)  The current version of the Dashboard.
        """
        return pulumi.get(self, "version")

