# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['CloudAccountArgs', 'CloudAccount']

@pulumi.input_type
class CloudAccountArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[str],
                 cloud_provider: pulumi.Input[str],
                 alias: Optional[pulumi.Input[str]] = None,
                 role_enabled: Optional[pulumi.Input[bool]] = None,
                 role_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CloudAccount resource.
        :param pulumi.Input[str] account_id: The unique identifier of the cloud account. e.g. for AWS: `123456789012`,
        :param pulumi.Input[str] cloud_provider: The cloud provider in which the account exists. Currently supported providers are `aws`, `gcp` and `azure`
        :param pulumi.Input[str] alias: A human friendly alias for `account_id`.
        :param pulumi.Input[bool] role_enabled: Whether or not a role is provisioned withing this account, that Sysdig has permission to AssumeRole in order to run Benchmarks. Default: `false`.
        :param pulumi.Input[str] role_name: The name of the role Sysdig will have permission to AssumeRole if `role_enaled` is set to `true`. Default: `SysdigCloudBench`.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "cloud_provider", cloud_provider)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if role_enabled is not None:
            pulumi.set(__self__, "role_enabled", role_enabled)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[str]:
        """
        The unique identifier of the cloud account. e.g. for AWS: `123456789012`,
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="cloudProvider")
    def cloud_provider(self) -> pulumi.Input[str]:
        """
        The cloud provider in which the account exists. Currently supported providers are `aws`, `gcp` and `azure`
        """
        return pulumi.get(self, "cloud_provider")

    @cloud_provider.setter
    def cloud_provider(self, value: pulumi.Input[str]):
        pulumi.set(self, "cloud_provider", value)

    @property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[str]]:
        """
        A human friendly alias for `account_id`.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alias", value)

    @property
    @pulumi.getter(name="roleEnabled")
    def role_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not a role is provisioned withing this account, that Sysdig has permission to AssumeRole in order to run Benchmarks. Default: `false`.
        """
        return pulumi.get(self, "role_enabled")

    @role_enabled.setter
    def role_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "role_enabled", value)

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the role Sysdig will have permission to AssumeRole if `role_enaled` is set to `true`. Default: `SysdigCloudBench`.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_name", value)


@pulumi.input_type
class _CloudAccountState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 alias: Optional[pulumi.Input[str]] = None,
                 cloud_provider: Optional[pulumi.Input[str]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 role_enabled: Optional[pulumi.Input[bool]] = None,
                 role_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CloudAccount resources.
        :param pulumi.Input[str] account_id: The unique identifier of the cloud account. e.g. for AWS: `123456789012`,
        :param pulumi.Input[str] alias: A human friendly alias for `account_id`.
        :param pulumi.Input[str] cloud_provider: The cloud provider in which the account exists. Currently supported providers are `aws`, `gcp` and `azure`
        :param pulumi.Input[bool] role_enabled: Whether or not a role is provisioned withing this account, that Sysdig has permission to AssumeRole in order to run Benchmarks. Default: `false`.
        :param pulumi.Input[str] role_name: The name of the role Sysdig will have permission to AssumeRole if `role_enaled` is set to `true`. Default: `SysdigCloudBench`.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if cloud_provider is not None:
            pulumi.set(__self__, "cloud_provider", cloud_provider)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if role_enabled is not None:
            pulumi.set(__self__, "role_enabled", role_enabled)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier of the cloud account. e.g. for AWS: `123456789012`,
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[str]]:
        """
        A human friendly alias for `account_id`.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alias", value)

    @property
    @pulumi.getter(name="cloudProvider")
    def cloud_provider(self) -> Optional[pulumi.Input[str]]:
        """
        The cloud provider in which the account exists. Currently supported providers are `aws`, `gcp` and `azure`
        """
        return pulumi.get(self, "cloud_provider")

    @cloud_provider.setter
    def cloud_provider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_provider", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="roleEnabled")
    def role_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not a role is provisioned withing this account, that Sysdig has permission to AssumeRole in order to run Benchmarks. Default: `false`.
        """
        return pulumi.get(self, "role_enabled")

    @role_enabled.setter
    def role_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "role_enabled", value)

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the role Sysdig will have permission to AssumeRole if `role_enaled` is set to `true`. Default: `SysdigCloudBench`.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_name", value)


class CloudAccount(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 alias: Optional[pulumi.Input[str]] = None,
                 cloud_provider: Optional[pulumi.Input[str]] = None,
                 role_enabled: Optional[pulumi.Input[bool]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Import

        Secure Cloud Accounts can be imported using the `account_id`, e.g.

        ```sh
         $ pulumi import sysdig:Secure/cloudAccount:CloudAccount sample 123456789012
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The unique identifier of the cloud account. e.g. for AWS: `123456789012`,
        :param pulumi.Input[str] alias: A human friendly alias for `account_id`.
        :param pulumi.Input[str] cloud_provider: The cloud provider in which the account exists. Currently supported providers are `aws`, `gcp` and `azure`
        :param pulumi.Input[bool] role_enabled: Whether or not a role is provisioned withing this account, that Sysdig has permission to AssumeRole in order to run Benchmarks. Default: `false`.
        :param pulumi.Input[str] role_name: The name of the role Sysdig will have permission to AssumeRole if `role_enaled` is set to `true`. Default: `SysdigCloudBench`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudAccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Secure Cloud Accounts can be imported using the `account_id`, e.g.

        ```sh
         $ pulumi import sysdig:Secure/cloudAccount:CloudAccount sample 123456789012
        ```

        :param str resource_name: The name of the resource.
        :param CloudAccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudAccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[str]] = None,
                 alias: Optional[pulumi.Input[str]] = None,
                 cloud_provider: Optional[pulumi.Input[str]] = None,
                 role_enabled: Optional[pulumi.Input[bool]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudAccountArgs.__new__(CloudAccountArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["alias"] = alias
            if cloud_provider is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_provider'")
            __props__.__dict__["cloud_provider"] = cloud_provider
            __props__.__dict__["role_enabled"] = role_enabled
            __props__.__dict__["role_name"] = role_name
            __props__.__dict__["external_id"] = None
        super(CloudAccount, __self__).__init__(
            'sysdig:Secure/cloudAccount:CloudAccount',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[str]] = None,
            alias: Optional[pulumi.Input[str]] = None,
            cloud_provider: Optional[pulumi.Input[str]] = None,
            external_id: Optional[pulumi.Input[str]] = None,
            role_enabled: Optional[pulumi.Input[bool]] = None,
            role_name: Optional[pulumi.Input[str]] = None) -> 'CloudAccount':
        """
        Get an existing CloudAccount resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_id: The unique identifier of the cloud account. e.g. for AWS: `123456789012`,
        :param pulumi.Input[str] alias: A human friendly alias for `account_id`.
        :param pulumi.Input[str] cloud_provider: The cloud provider in which the account exists. Currently supported providers are `aws`, `gcp` and `azure`
        :param pulumi.Input[bool] role_enabled: Whether or not a role is provisioned withing this account, that Sysdig has permission to AssumeRole in order to run Benchmarks. Default: `false`.
        :param pulumi.Input[str] role_name: The name of the role Sysdig will have permission to AssumeRole if `role_enaled` is set to `true`. Default: `SysdigCloudBench`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudAccountState.__new__(_CloudAccountState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["alias"] = alias
        __props__.__dict__["cloud_provider"] = cloud_provider
        __props__.__dict__["external_id"] = external_id
        __props__.__dict__["role_enabled"] = role_enabled
        __props__.__dict__["role_name"] = role_name
        return CloudAccount(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[str]:
        """
        The unique identifier of the cloud account. e.g. for AWS: `123456789012`,
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def alias(self) -> pulumi.Output[Optional[str]]:
        """
        A human friendly alias for `account_id`.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="cloudProvider")
    def cloud_provider(self) -> pulumi.Output[str]:
        """
        The cloud provider in which the account exists. Currently supported providers are `aws`, `gcp` and `azure`
        """
        return pulumi.get(self, "cloud_provider")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="roleEnabled")
    def role_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not a role is provisioned withing this account, that Sysdig has permission to AssumeRole in order to run Benchmarks. Default: `false`.
        """
        return pulumi.get(self, "role_enabled")

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the role Sysdig will have permission to AssumeRole if `role_enaled` is set to `true`. Default: `SysdigCloudBench`.
        """
        return pulumi.get(self, "role_name")

