# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetNotificationChannelResult',
    'AwaitableGetNotificationChannelResult',
    'get_notification_channel',
    'get_notification_channel_output',
]

@pulumi.output_type
class GetNotificationChannelResult:
    """
    A collection of values returned by GetNotificationChannel.
    """
    def __init__(__self__, account=None, api_key=None, channel=None, enabled=None, id=None, name=None, notify_when_ok=None, notify_when_resolved=None, recipients=None, routing_key=None, send_test_notification=None, service_key=None, service_name=None, topics=None, type=None, url=None, version=None):
        if account and not isinstance(account, str):
            raise TypeError("Expected argument 'account' to be a str")
        pulumi.set(__self__, "account", account)
        if api_key and not isinstance(api_key, str):
            raise TypeError("Expected argument 'api_key' to be a str")
        pulumi.set(__self__, "api_key", api_key)
        if channel and not isinstance(channel, str):
            raise TypeError("Expected argument 'channel' to be a str")
        pulumi.set(__self__, "channel", channel)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if notify_when_ok and not isinstance(notify_when_ok, bool):
            raise TypeError("Expected argument 'notify_when_ok' to be a bool")
        pulumi.set(__self__, "notify_when_ok", notify_when_ok)
        if notify_when_resolved and not isinstance(notify_when_resolved, bool):
            raise TypeError("Expected argument 'notify_when_resolved' to be a bool")
        pulumi.set(__self__, "notify_when_resolved", notify_when_resolved)
        if recipients and not isinstance(recipients, str):
            raise TypeError("Expected argument 'recipients' to be a str")
        pulumi.set(__self__, "recipients", recipients)
        if routing_key and not isinstance(routing_key, str):
            raise TypeError("Expected argument 'routing_key' to be a str")
        pulumi.set(__self__, "routing_key", routing_key)
        if send_test_notification and not isinstance(send_test_notification, bool):
            raise TypeError("Expected argument 'send_test_notification' to be a bool")
        pulumi.set(__self__, "send_test_notification", send_test_notification)
        if service_key and not isinstance(service_key, str):
            raise TypeError("Expected argument 'service_key' to be a str")
        pulumi.set(__self__, "service_key", service_key)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if topics and not isinstance(topics, str):
            raise TypeError("Expected argument 'topics' to be a str")
        pulumi.set(__self__, "topics", topics)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def account(self) -> str:
        """
        Pagerduty account.
        """
        return pulumi.get(self, "account")

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> str:
        """
        Key for the API.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter
    def channel(self) -> str:
        """
        Channel name from this Slack.
        """
        return pulumi.get(self, "channel")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        If false, the channel will not emit notifications.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notifyWhenOk")
    def notify_when_ok(self) -> bool:
        """
        Send a new notification when the alert condition is 
        no longer triggered.
        """
        return pulumi.get(self, "notify_when_ok")

    @property
    @pulumi.getter(name="notifyWhenResolved")
    def notify_when_resolved(self) -> bool:
        """
        Send a new notification when the alert is manually 
        acknowledged by a user.
        """
        return pulumi.get(self, "notify_when_resolved")

    @property
    @pulumi.getter
    def recipients(self) -> str:
        """
        Comma-separated list of recipients that will receive 
        the message.
        """
        return pulumi.get(self, "recipients")

    @property
    @pulumi.getter(name="routingKey")
    def routing_key(self) -> str:
        """
        Routing key for VictorOps.
        """
        return pulumi.get(self, "routing_key")

    @property
    @pulumi.getter(name="sendTestNotification")
    def send_test_notification(self) -> bool:
        """
        Send an initial test notification to check
        if the notification channel is working.
        """
        return pulumi.get(self, "send_test_notification")

    @property
    @pulumi.getter(name="serviceKey")
    def service_key(self) -> str:
        """
        Service Key for the Pagerduty account.
        """
        return pulumi.get(self, "service_key")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        Service name for the Pagerduty account.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def topics(self) -> str:
        """
        List of ARNs from the SNS topics.
        """
        return pulumi.get(self, "topics")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Will be one of the following:  "EMAIL", "SNS", "OPSGENIE", 
        "VICTOROPS", "WEBHOOK", "SLACK", "PAGER_DUTY".
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        URL of the Slack.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def version(self) -> int:
        return pulumi.get(self, "version")


class AwaitableGetNotificationChannelResult(GetNotificationChannelResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNotificationChannelResult(
            account=self.account,
            api_key=self.api_key,
            channel=self.channel,
            enabled=self.enabled,
            id=self.id,
            name=self.name,
            notify_when_ok=self.notify_when_ok,
            notify_when_resolved=self.notify_when_resolved,
            recipients=self.recipients,
            routing_key=self.routing_key,
            send_test_notification=self.send_test_notification,
            service_key=self.service_key,
            service_name=self.service_name,
            topics=self.topics,
            type=self.type,
            url=self.url,
            version=self.version)


def get_notification_channel(name: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNotificationChannelResult:
    """
    Use this data source to access information about an existing resource.

    :param str name: The name of the Notification Channel.
    """
    __args__ = dict()
    __args__['name'] = name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('sysdig:Secure/getNotificationChannel:GetNotificationChannel', __args__, opts=opts, typ=GetNotificationChannelResult).value

    return AwaitableGetNotificationChannelResult(
        account=__ret__.account,
        api_key=__ret__.api_key,
        channel=__ret__.channel,
        enabled=__ret__.enabled,
        id=__ret__.id,
        name=__ret__.name,
        notify_when_ok=__ret__.notify_when_ok,
        notify_when_resolved=__ret__.notify_when_resolved,
        recipients=__ret__.recipients,
        routing_key=__ret__.routing_key,
        send_test_notification=__ret__.send_test_notification,
        service_key=__ret__.service_key,
        service_name=__ret__.service_name,
        topics=__ret__.topics,
        type=__ret__.type,
        url=__ret__.url,
        version=__ret__.version)


@_utilities.lift_output_func(get_notification_channel)
def get_notification_channel_output(name: Optional[pulumi.Input[str]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNotificationChannelResult]:
    """
    Use this data source to access information about an existing resource.

    :param str name: The name of the Notification Channel.
    """
    ...
