# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetTrustedCloudIdentityResult',
    'AwaitableGetTrustedCloudIdentityResult',
    'get_trusted_cloud_identity',
    'get_trusted_cloud_identity_output',
]

@pulumi.output_type
class GetTrustedCloudIdentityResult:
    """
    A collection of values returned by GetTrustedCloudIdentity.
    """
    def __init__(__self__, aws_account_id=None, aws_role_name=None, azure_service_principal_id=None, azure_tenant_id=None, cloud_provider=None, id=None, identity=None):
        if aws_account_id and not isinstance(aws_account_id, str):
            raise TypeError("Expected argument 'aws_account_id' to be a str")
        pulumi.set(__self__, "aws_account_id", aws_account_id)
        if aws_role_name and not isinstance(aws_role_name, str):
            raise TypeError("Expected argument 'aws_role_name' to be a str")
        pulumi.set(__self__, "aws_role_name", aws_role_name)
        if azure_service_principal_id and not isinstance(azure_service_principal_id, str):
            raise TypeError("Expected argument 'azure_service_principal_id' to be a str")
        pulumi.set(__self__, "azure_service_principal_id", azure_service_principal_id)
        if azure_tenant_id and not isinstance(azure_tenant_id, str):
            raise TypeError("Expected argument 'azure_tenant_id' to be a str")
        pulumi.set(__self__, "azure_tenant_id", azure_tenant_id)
        if cloud_provider and not isinstance(cloud_provider, str):
            raise TypeError("Expected argument 'cloud_provider' to be a str")
        pulumi.set(__self__, "cloud_provider", cloud_provider)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identity and not isinstance(identity, str):
            raise TypeError("Expected argument 'identity' to be a str")
        pulumi.set(__self__, "identity", identity)

    @property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> str:
        """
        If `identity` is an AWS ARN, this attribute contains the AWS Account ID to which the ARN belongs, otherwise it contains the empty string. `cloud_provider` must be equal to `aws` or `gcp`.
        """
        return pulumi.get(self, "aws_account_id")

    @property
    @pulumi.getter(name="awsRoleName")
    def aws_role_name(self) -> str:
        """
        If `identity` is a AWS IAM Role ARN, this attribute contains the name of the role, otherwise it contains the empty string. `cloud_provider` must be equal to `aws` or `gcp`.
        """
        return pulumi.get(self, "aws_role_name")

    @property
    @pulumi.getter(name="azureServicePrincipalId")
    def azure_service_principal_id(self) -> str:
        """
        If `identity` contains credentials for an Azure Service Principal, this attribute contains the service principal's ID. `cloud_provider` must be equal to `azure`.
        """
        return pulumi.get(self, "azure_service_principal_id")

    @property
    @pulumi.getter(name="azureTenantId")
    def azure_tenant_id(self) -> str:
        """
        If `identity` contains credentials for an Azure Service Principal, this attribute contains the service principal's Tenant ID. `cloud_provider` must be equal to `azure`.
        """
        return pulumi.get(self, "azure_tenant_id")

    @property
    @pulumi.getter(name="cloudProvider")
    def cloud_provider(self) -> str:
        return pulumi.get(self, "cloud_provider")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identity(self) -> str:
        """
        Sysdig's identity (User/Role/etc) that should be used to create a trust relationship allowing Sysdig access to your cloud account.
        """
        return pulumi.get(self, "identity")


class AwaitableGetTrustedCloudIdentityResult(GetTrustedCloudIdentityResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTrustedCloudIdentityResult(
            aws_account_id=self.aws_account_id,
            aws_role_name=self.aws_role_name,
            azure_service_principal_id=self.azure_service_principal_id,
            azure_tenant_id=self.azure_tenant_id,
            cloud_provider=self.cloud_provider,
            id=self.id,
            identity=self.identity)


def get_trusted_cloud_identity(cloud_provider: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTrustedCloudIdentityResult:
    """
    Use this data source to access information about an existing resource.

    :param str cloud_provider: The cloud provider in which the trusted identity will be used. Currently supported providers are `aws`, `gcp` and `azure`
    """
    __args__ = dict()
    __args__['cloudProvider'] = cloud_provider
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('sysdig:Secure/getTrustedCloudIdentity:GetTrustedCloudIdentity', __args__, opts=opts, typ=GetTrustedCloudIdentityResult).value

    return AwaitableGetTrustedCloudIdentityResult(
        aws_account_id=__ret__.aws_account_id,
        aws_role_name=__ret__.aws_role_name,
        azure_service_principal_id=__ret__.azure_service_principal_id,
        azure_tenant_id=__ret__.azure_tenant_id,
        cloud_provider=__ret__.cloud_provider,
        id=__ret__.id,
        identity=__ret__.identity)


@_utilities.lift_output_func(get_trusted_cloud_identity)
def get_trusted_cloud_identity_output(cloud_provider: Optional[pulumi.Input[str]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTrustedCloudIdentityResult]:
    """
    Use this data source to access information about an existing resource.

    :param str cloud_provider: The cloud provider in which the trusted identity will be used. Currently supported providers are `aws`, `gcp` and `azure`
    """
    ...
