# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ListArgs', 'List']

@pulumi.input_type
class ListArgs:
    def __init__(__self__, *,
                 items: pulumi.Input[Sequence[pulumi.Input[str]]],
                 append: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a List resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] items: Elements in the list. Elements can be another lists.
        :param pulumi.Input[bool] append: Adds these elements to an existing list. Used to extend existing lists provided by Sysdig.
               The rules can only be extended once, for example if there is an existing list called "foo", one can have another
               append rule called "foo" but not a second one. By default this is false.
        :param pulumi.Input[str] name: The name of the Secure list. It must be unique if it's not in append mode.
        """
        pulumi.set(__self__, "items", items)
        if append is not None:
            pulumi.set(__self__, "append", append)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def items(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Elements in the list. Elements can be another lists.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "items", value)

    @property
    @pulumi.getter
    def append(self) -> Optional[pulumi.Input[bool]]:
        """
        Adds these elements to an existing list. Used to extend existing lists provided by Sysdig.
        The rules can only be extended once, for example if there is an existing list called "foo", one can have another
        append rule called "foo" but not a second one. By default this is false.
        """
        return pulumi.get(self, "append")

    @append.setter
    def append(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "append", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Secure list. It must be unique if it's not in append mode.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ListState:
    def __init__(__self__, *,
                 append: Optional[pulumi.Input[bool]] = None,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering List resources.
        :param pulumi.Input[bool] append: Adds these elements to an existing list. Used to extend existing lists provided by Sysdig.
               The rules can only be extended once, for example if there is an existing list called "foo", one can have another
               append rule called "foo" but not a second one. By default this is false.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] items: Elements in the list. Elements can be another lists.
        :param pulumi.Input[str] name: The name of the Secure list. It must be unique if it's not in append mode.
        """
        if append is not None:
            pulumi.set(__self__, "append", append)
        if items is not None:
            pulumi.set(__self__, "items", items)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def append(self) -> Optional[pulumi.Input[bool]]:
        """
        Adds these elements to an existing list. Used to extend existing lists provided by Sysdig.
        The rules can only be extended once, for example if there is an existing list called "foo", one can have another
        append rule called "foo" but not a second one. By default this is false.
        """
        return pulumi.get(self, "append")

    @append.setter
    def append(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "append", value)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Elements in the list. Elements can be another lists.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "items", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Secure list. It must be unique if it's not in append mode.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class List(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 append: Optional[pulumi.Input[bool]] = None,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Import

        Secure lists can be imported using the ID, e.g.

        ```sh
         $ pulumi import sysdig:Secure/list:List example 12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] append: Adds these elements to an existing list. Used to extend existing lists provided by Sysdig.
               The rules can only be extended once, for example if there is an existing list called "foo", one can have another
               append rule called "foo" but not a second one. By default this is false.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] items: Elements in the list. Elements can be another lists.
        :param pulumi.Input[str] name: The name of the Secure list. It must be unique if it's not in append mode.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ListArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Secure lists can be imported using the ID, e.g.

        ```sh
         $ pulumi import sysdig:Secure/list:List example 12345
        ```

        :param str resource_name: The name of the resource.
        :param ListArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ListArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 append: Optional[pulumi.Input[bool]] = None,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ListArgs.__new__(ListArgs)

            __props__.__dict__["append"] = append
            if items is None and not opts.urn:
                raise TypeError("Missing required property 'items'")
            __props__.__dict__["items"] = items
            __props__.__dict__["name"] = name
            __props__.__dict__["version"] = None
        super(List, __self__).__init__(
            'sysdig:Secure/list:List',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            append: Optional[pulumi.Input[bool]] = None,
            items: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'List':
        """
        Get an existing List resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] append: Adds these elements to an existing list. Used to extend existing lists provided by Sysdig.
               The rules can only be extended once, for example if there is an existing list called "foo", one can have another
               append rule called "foo" but not a second one. By default this is false.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] items: Elements in the list. Elements can be another lists.
        :param pulumi.Input[str] name: The name of the Secure list. It must be unique if it's not in append mode.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ListState.__new__(_ListState)

        __props__.__dict__["append"] = append
        __props__.__dict__["items"] = items
        __props__.__dict__["name"] = name
        __props__.__dict__["version"] = version
        return List(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def append(self) -> pulumi.Output[Optional[bool]]:
        """
        Adds these elements to an existing list. Used to extend existing lists provided by Sysdig.
        The rules can only be extended once, for example if there is an existing list called "foo", one can have another
        append rule called "foo" but not a second one. By default this is false.
        """
        return pulumi.get(self, "append")

    @property
    @pulumi.getter
    def items(self) -> pulumi.Output[Sequence[str]]:
        """
        Elements in the list. Elements can be another lists.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Secure list. It must be unique if it's not in append mode.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        return pulumi.get(self, "version")

