# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['MacroArgs', 'Macro']

@pulumi.input_type
class MacroArgs:
    def __init__(__self__, *,
                 condition: pulumi.Input[str],
                 append: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Macro resource.
        :param pulumi.Input[str] condition: Macro condition. It can contain lists or other macros.
        :param pulumi.Input[bool] append: Adds these elements to an existing macro. Used to extend existing macros provided by Sysdig.
               The macros can only be extended once, for example if there is an existing macro called "foo", one can have another
               append macro called "foo" but not a second one. By default this is false.
        :param pulumi.Input[str] name: The name of the macro. It must be unique if it's not in append mode.
        """
        pulumi.set(__self__, "condition", condition)
        if append is not None:
            pulumi.set(__self__, "append", append)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def condition(self) -> pulumi.Input[str]:
        """
        Macro condition. It can contain lists or other macros.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: pulumi.Input[str]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def append(self) -> Optional[pulumi.Input[bool]]:
        """
        Adds these elements to an existing macro. Used to extend existing macros provided by Sysdig.
        The macros can only be extended once, for example if there is an existing macro called "foo", one can have another
        append macro called "foo" but not a second one. By default this is false.
        """
        return pulumi.get(self, "append")

    @append.setter
    def append(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "append", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the macro. It must be unique if it's not in append mode.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _MacroState:
    def __init__(__self__, *,
                 append: Optional[pulumi.Input[bool]] = None,
                 condition: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Macro resources.
        :param pulumi.Input[bool] append: Adds these elements to an existing macro. Used to extend existing macros provided by Sysdig.
               The macros can only be extended once, for example if there is an existing macro called "foo", one can have another
               append macro called "foo" but not a second one. By default this is false.
        :param pulumi.Input[str] condition: Macro condition. It can contain lists or other macros.
        :param pulumi.Input[str] name: The name of the macro. It must be unique if it's not in append mode.
        """
        if append is not None:
            pulumi.set(__self__, "append", append)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def append(self) -> Optional[pulumi.Input[bool]]:
        """
        Adds these elements to an existing macro. Used to extend existing macros provided by Sysdig.
        The macros can only be extended once, for example if there is an existing macro called "foo", one can have another
        append macro called "foo" but not a second one. By default this is false.
        """
        return pulumi.get(self, "append")

    @append.setter
    def append(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "append", value)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input[str]]:
        """
        Macro condition. It can contain lists or other macros.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the macro. It must be unique if it's not in append mode.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class Macro(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 append: Optional[pulumi.Input[bool]] = None,
                 condition: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Import

        Secure macros can be imported using the ID, e.g.

        ```sh
         $ pulumi import sysdig:Secure/macro:Macro example 12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] append: Adds these elements to an existing macro. Used to extend existing macros provided by Sysdig.
               The macros can only be extended once, for example if there is an existing macro called "foo", one can have another
               append macro called "foo" but not a second one. By default this is false.
        :param pulumi.Input[str] condition: Macro condition. It can contain lists or other macros.
        :param pulumi.Input[str] name: The name of the macro. It must be unique if it's not in append mode.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MacroArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Secure macros can be imported using the ID, e.g.

        ```sh
         $ pulumi import sysdig:Secure/macro:Macro example 12345
        ```

        :param str resource_name: The name of the resource.
        :param MacroArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MacroArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 append: Optional[pulumi.Input[bool]] = None,
                 condition: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MacroArgs.__new__(MacroArgs)

            __props__.__dict__["append"] = append
            if condition is None and not opts.urn:
                raise TypeError("Missing required property 'condition'")
            __props__.__dict__["condition"] = condition
            __props__.__dict__["name"] = name
            __props__.__dict__["version"] = None
        super(Macro, __self__).__init__(
            'sysdig:Secure/macro:Macro',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            append: Optional[pulumi.Input[bool]] = None,
            condition: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'Macro':
        """
        Get an existing Macro resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] append: Adds these elements to an existing macro. Used to extend existing macros provided by Sysdig.
               The macros can only be extended once, for example if there is an existing macro called "foo", one can have another
               append macro called "foo" but not a second one. By default this is false.
        :param pulumi.Input[str] condition: Macro condition. It can contain lists or other macros.
        :param pulumi.Input[str] name: The name of the macro. It must be unique if it's not in append mode.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MacroState.__new__(_MacroState)

        __props__.__dict__["append"] = append
        __props__.__dict__["condition"] = condition
        __props__.__dict__["name"] = name
        __props__.__dict__["version"] = version
        return Macro(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def append(self) -> pulumi.Output[Optional[bool]]:
        """
        Adds these elements to an existing macro. Used to extend existing macros provided by Sysdig.
        The macros can only be extended once, for example if there is an existing macro called "foo", one can have another
        append macro called "foo" but not a second one. By default this is false.
        """
        return pulumi.get(self, "append")

    @property
    @pulumi.getter
    def condition(self) -> pulumi.Output[str]:
        """
        Macro condition. It can contain lists or other macros.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the macro. It must be unique if it's not in append mode.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        return pulumi.get(self, "version")

