# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PolicyArgs', 'Policy']

@pulumi.input_type
class PolicyArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyActionArgs']]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_channels: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 rule_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 severity: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Policy resource.
        :param pulumi.Input[str] description: The description of Secure policy.
        :param pulumi.Input[bool] enabled: Will secure process with this rule?. By default this is true.
        :param pulumi.Input[str] name: The name of the Secure policy. It must be unique.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] notification_channels: IDs of the notification channels to send alerts to
               when the policy is fired.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rule_names: Array with the name of the rules to match.
        :param pulumi.Input[str] scope: Limit appplication scope based in one expresion. For
               example: "host.ip.private = \\"10.0.23.1\\"". By default the rule won't be scoped
               and will target the entire infrastructure.
        :param pulumi.Input[int] severity: The severity of Secure policy. The accepted values
               are: 0, 1, 2, 3 (High), 4, 5 (Medium), 6 (Low) and 7 (Info). The default value is 4 (Medium).
        :param pulumi.Input[str] type: Specifies the type of the runtime policy. Must be one of: `falco`, `list_matching`, `k8s_audit`, `aws_cloudtrail`. By default it is `falco`.
        """
        pulumi.set(__self__, "description", description)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_channels is not None:
            pulumi.set(__self__, "notification_channels", notification_channels)
        if rule_names is not None:
            pulumi.set(__self__, "rule_names", rule_names)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        The description of Secure policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PolicyActionArgs']]]]:
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Will secure process with this rule?. By default this is true.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Secure policy. It must be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notificationChannels")
    def notification_channels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        IDs of the notification channels to send alerts to
        when the policy is fired.
        """
        return pulumi.get(self, "notification_channels")

    @notification_channels.setter
    def notification_channels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "notification_channels", value)

    @property
    @pulumi.getter(name="ruleNames")
    def rule_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Array with the name of the rules to match.
        """
        return pulumi.get(self, "rule_names")

    @rule_names.setter
    def rule_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "rule_names", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        Limit appplication scope based in one expresion. For
        example: "host.ip.private = \\"10.0.23.1\\"". By default the rule won't be scoped
        and will target the entire infrastructure.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[int]]:
        """
        The severity of Secure policy. The accepted values
        are: 0, 1, 2, 3 (High), 4, 5 (Medium), 6 (Low) and 7 (Info). The default value is 4 (Medium).
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of the runtime policy. Must be one of: `falco`, `list_matching`, `k8s_audit`, `aws_cloudtrail`. By default it is `falco`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _PolicyState:
    def __init__(__self__, *,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyActionArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_channels: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 rule_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 severity: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Policy resources.
        :param pulumi.Input[str] description: The description of Secure policy.
        :param pulumi.Input[bool] enabled: Will secure process with this rule?. By default this is true.
        :param pulumi.Input[str] name: The name of the Secure policy. It must be unique.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] notification_channels: IDs of the notification channels to send alerts to
               when the policy is fired.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rule_names: Array with the name of the rules to match.
        :param pulumi.Input[str] scope: Limit appplication scope based in one expresion. For
               example: "host.ip.private = \\"10.0.23.1\\"". By default the rule won't be scoped
               and will target the entire infrastructure.
        :param pulumi.Input[int] severity: The severity of Secure policy. The accepted values
               are: 0, 1, 2, 3 (High), 4, 5 (Medium), 6 (Low) and 7 (Info). The default value is 4 (Medium).
        :param pulumi.Input[str] type: Specifies the type of the runtime policy. Must be one of: `falco`, `list_matching`, `k8s_audit`, `aws_cloudtrail`. By default it is `falco`.
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_channels is not None:
            pulumi.set(__self__, "notification_channels", notification_channels)
        if rule_names is not None:
            pulumi.set(__self__, "rule_names", rule_names)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PolicyActionArgs']]]]:
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of Secure policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Will secure process with this rule?. By default this is true.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Secure policy. It must be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notificationChannels")
    def notification_channels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        IDs of the notification channels to send alerts to
        when the policy is fired.
        """
        return pulumi.get(self, "notification_channels")

    @notification_channels.setter
    def notification_channels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "notification_channels", value)

    @property
    @pulumi.getter(name="ruleNames")
    def rule_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Array with the name of the rules to match.
        """
        return pulumi.get(self, "rule_names")

    @rule_names.setter
    def rule_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "rule_names", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        Limit appplication scope based in one expresion. For
        example: "host.ip.private = \\"10.0.23.1\\"". By default the rule won't be scoped
        and will target the entire infrastructure.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[int]]:
        """
        The severity of Secure policy. The accepted values
        are: 0, 1, 2, 3 (High), 4, 5 (Medium), 6 (Low) and 7 (Info). The default value is 4 (Medium).
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of the runtime policy. Must be one of: `falco`, `list_matching`, `k8s_audit`, `aws_cloudtrail`. By default it is `falco`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class Policy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PolicyActionArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_channels: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 rule_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 severity: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Import

        Secure runtime policies can be imported using the ID, e.g.

        ```sh
         $ pulumi import sysdig:Secure/policy:Policy example 12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of Secure policy.
        :param pulumi.Input[bool] enabled: Will secure process with this rule?. By default this is true.
        :param pulumi.Input[str] name: The name of the Secure policy. It must be unique.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] notification_channels: IDs of the notification channels to send alerts to
               when the policy is fired.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rule_names: Array with the name of the rules to match.
        :param pulumi.Input[str] scope: Limit appplication scope based in one expresion. For
               example: "host.ip.private = \\"10.0.23.1\\"". By default the rule won't be scoped
               and will target the entire infrastructure.
        :param pulumi.Input[int] severity: The severity of Secure policy. The accepted values
               are: 0, 1, 2, 3 (High), 4, 5 (Medium), 6 (Low) and 7 (Info). The default value is 4 (Medium).
        :param pulumi.Input[str] type: Specifies the type of the runtime policy. Must be one of: `falco`, `list_matching`, `k8s_audit`, `aws_cloudtrail`. By default it is `falco`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Secure runtime policies can be imported using the ID, e.g.

        ```sh
         $ pulumi import sysdig:Secure/policy:Policy example 12345
        ```

        :param str resource_name: The name of the resource.
        :param PolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PolicyActionArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_channels: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 rule_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 severity: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyArgs.__new__(PolicyArgs)

            __props__.__dict__["actions"] = actions
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["name"] = name
            __props__.__dict__["notification_channels"] = notification_channels
            __props__.__dict__["rule_names"] = rule_names
            __props__.__dict__["scope"] = scope
            __props__.__dict__["severity"] = severity
            __props__.__dict__["type"] = type
            __props__.__dict__["version"] = None
        super(Policy, __self__).__init__(
            'sysdig:Secure/policy:Policy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PolicyActionArgs']]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            notification_channels: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            rule_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            scope: Optional[pulumi.Input[str]] = None,
            severity: Optional[pulumi.Input[int]] = None,
            type: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'Policy':
        """
        Get an existing Policy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of Secure policy.
        :param pulumi.Input[bool] enabled: Will secure process with this rule?. By default this is true.
        :param pulumi.Input[str] name: The name of the Secure policy. It must be unique.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] notification_channels: IDs of the notification channels to send alerts to
               when the policy is fired.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rule_names: Array with the name of the rules to match.
        :param pulumi.Input[str] scope: Limit appplication scope based in one expresion. For
               example: "host.ip.private = \\"10.0.23.1\\"". By default the rule won't be scoped
               and will target the entire infrastructure.
        :param pulumi.Input[int] severity: The severity of Secure policy. The accepted values
               are: 0, 1, 2, 3 (High), 4, 5 (Medium), 6 (Low) and 7 (Info). The default value is 4 (Medium).
        :param pulumi.Input[str] type: Specifies the type of the runtime policy. Must be one of: `falco`, `list_matching`, `k8s_audit`, `aws_cloudtrail`. By default it is `falco`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyState.__new__(_PolicyState)

        __props__.__dict__["actions"] = actions
        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["notification_channels"] = notification_channels
        __props__.__dict__["rule_names"] = rule_names
        __props__.__dict__["scope"] = scope
        __props__.__dict__["severity"] = severity
        __props__.__dict__["type"] = type
        __props__.__dict__["version"] = version
        return Policy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def actions(self) -> pulumi.Output[Optional[Sequence['outputs.PolicyAction']]]:
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of Secure policy.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Will secure process with this rule?. By default this is true.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Secure policy. It must be unique.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notificationChannels")
    def notification_channels(self) -> pulumi.Output[Optional[Sequence[int]]]:
        """
        IDs of the notification channels to send alerts to
        when the policy is fired.
        """
        return pulumi.get(self, "notification_channels")

    @property
    @pulumi.getter(name="ruleNames")
    def rule_names(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Array with the name of the rules to match.
        """
        return pulumi.get(self, "rule_names")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[Optional[str]]:
        """
        Limit appplication scope based in one expresion. For
        example: "host.ip.private = \\"10.0.23.1\\"". By default the rule won't be scoped
        and will target the entire infrastructure.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def severity(self) -> pulumi.Output[Optional[int]]:
        """
        The severity of Secure policy. The accepted values
        are: 0, 1, 2, 3 (High), 4, 5 (Medium), 6 (Low) and 7 (Info). The default value is 4 (Medium).
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the type of the runtime policy. Must be one of: `falco`, `list_matching`, `k8s_audit`, `aws_cloudtrail`. By default it is `falco`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        return pulumi.get(self, "version")

