# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RuleFalcoArgs', 'RuleFalco']

@pulumi.input_type
class RuleFalcoArgs:
    def __init__(__self__, *,
                 condition: pulumi.Input[str],
                 append: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 exceptions: Optional[pulumi.Input[Sequence[pulumi.Input['RuleFalcoExceptionArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a RuleFalco resource.
        :param pulumi.Input[str] condition: A [Falco condition](https://falco.org/docs/rules/) is simply a Boolean predicate on Sysdig events expressed using the Sysdig [filter syntax](http://www.sysdig.org/wiki/sysdig-user-guide/#filtering) and macro terms.
        :param pulumi.Input[bool] append: This indicates that the rule being created appends the condition to an existing Sysdig-provided rule. By default this is false. Appending to user-created rules is not supported by the API.
        :param pulumi.Input[str] description: The description of Secure rule. By default is empty.
        :param pulumi.Input[Sequence[pulumi.Input['RuleFalcoExceptionArgs']]] exceptions: The exceptions key is a list of identifier plus list of tuples of filtercheck fields. See below for details.
        :param pulumi.Input[str] name: The name of the exception. Only used to provide a handy name, and to potentially link together values in a later rule that has `append = true`.
        :param pulumi.Input[str] output: Add additional information to each Falco notification's output. Required if append is false.
        :param pulumi.Input[str] priority: The priority of the Falco rule. It can be: "emergency", "alert", "critical", "error", "warning", "notice", "info" or "debug". By default is "warning".
        :param pulumi.Input[str] source: The source of the event. It can be either "syscall", "k8s_audit" or "aws_cloudtrail". Required if append is false.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags for this rule.
        """
        pulumi.set(__self__, "condition", condition)
        if append is not None:
            pulumi.set(__self__, "append", append)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if exceptions is not None:
            pulumi.set(__self__, "exceptions", exceptions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output is not None:
            pulumi.set(__self__, "output", output)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def condition(self) -> pulumi.Input[str]:
        """
        A [Falco condition](https://falco.org/docs/rules/) is simply a Boolean predicate on Sysdig events expressed using the Sysdig [filter syntax](http://www.sysdig.org/wiki/sysdig-user-guide/#filtering) and macro terms.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: pulumi.Input[str]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def append(self) -> Optional[pulumi.Input[bool]]:
        """
        This indicates that the rule being created appends the condition to an existing Sysdig-provided rule. By default this is false. Appending to user-created rules is not supported by the API.
        """
        return pulumi.get(self, "append")

    @append.setter
    def append(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "append", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of Secure rule. By default is empty.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def exceptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleFalcoExceptionArgs']]]]:
        """
        The exceptions key is a list of identifier plus list of tuples of filtercheck fields. See below for details.
        """
        return pulumi.get(self, "exceptions")

    @exceptions.setter
    def exceptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleFalcoExceptionArgs']]]]):
        pulumi.set(self, "exceptions", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the exception. Only used to provide a handy name, and to potentially link together values in a later rule that has `append = true`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def output(self) -> Optional[pulumi.Input[str]]:
        """
        Add additional information to each Falco notification's output. Required if append is false.
        """
        return pulumi.get(self, "output")

    @output.setter
    def output(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[str]]:
        """
        The priority of the Falco rule. It can be: "emergency", "alert", "critical", "error", "warning", "notice", "info" or "debug". By default is "warning".
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        The source of the event. It can be either "syscall", "k8s_audit" or "aws_cloudtrail". Required if append is false.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of tags for this rule.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _RuleFalcoState:
    def __init__(__self__, *,
                 append: Optional[pulumi.Input[bool]] = None,
                 condition: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 exceptions: Optional[pulumi.Input[Sequence[pulumi.Input['RuleFalcoExceptionArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering RuleFalco resources.
        :param pulumi.Input[bool] append: This indicates that the rule being created appends the condition to an existing Sysdig-provided rule. By default this is false. Appending to user-created rules is not supported by the API.
        :param pulumi.Input[str] condition: A [Falco condition](https://falco.org/docs/rules/) is simply a Boolean predicate on Sysdig events expressed using the Sysdig [filter syntax](http://www.sysdig.org/wiki/sysdig-user-guide/#filtering) and macro terms.
        :param pulumi.Input[str] description: The description of Secure rule. By default is empty.
        :param pulumi.Input[Sequence[pulumi.Input['RuleFalcoExceptionArgs']]] exceptions: The exceptions key is a list of identifier plus list of tuples of filtercheck fields. See below for details.
        :param pulumi.Input[str] name: The name of the exception. Only used to provide a handy name, and to potentially link together values in a later rule that has `append = true`.
        :param pulumi.Input[str] output: Add additional information to each Falco notification's output. Required if append is false.
        :param pulumi.Input[str] priority: The priority of the Falco rule. It can be: "emergency", "alert", "critical", "error", "warning", "notice", "info" or "debug". By default is "warning".
        :param pulumi.Input[str] source: The source of the event. It can be either "syscall", "k8s_audit" or "aws_cloudtrail". Required if append is false.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags for this rule.
        :param pulumi.Input[int] version: Current version of the resource in Sysdig Secure.
        """
        if append is not None:
            pulumi.set(__self__, "append", append)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if exceptions is not None:
            pulumi.set(__self__, "exceptions", exceptions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output is not None:
            pulumi.set(__self__, "output", output)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def append(self) -> Optional[pulumi.Input[bool]]:
        """
        This indicates that the rule being created appends the condition to an existing Sysdig-provided rule. By default this is false. Appending to user-created rules is not supported by the API.
        """
        return pulumi.get(self, "append")

    @append.setter
    def append(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "append", value)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input[str]]:
        """
        A [Falco condition](https://falco.org/docs/rules/) is simply a Boolean predicate on Sysdig events expressed using the Sysdig [filter syntax](http://www.sysdig.org/wiki/sysdig-user-guide/#filtering) and macro terms.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of Secure rule. By default is empty.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def exceptions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleFalcoExceptionArgs']]]]:
        """
        The exceptions key is a list of identifier plus list of tuples of filtercheck fields. See below for details.
        """
        return pulumi.get(self, "exceptions")

    @exceptions.setter
    def exceptions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleFalcoExceptionArgs']]]]):
        pulumi.set(self, "exceptions", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the exception. Only used to provide a handy name, and to potentially link together values in a later rule that has `append = true`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def output(self) -> Optional[pulumi.Input[str]]:
        """
        Add additional information to each Falco notification's output. Required if append is false.
        """
        return pulumi.get(self, "output")

    @output.setter
    def output(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[str]]:
        """
        The priority of the Falco rule. It can be: "emergency", "alert", "critical", "error", "warning", "notice", "info" or "debug". By default is "warning".
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        The source of the event. It can be either "syscall", "k8s_audit" or "aws_cloudtrail". Required if append is false.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of tags for this rule.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        Current version of the resource in Sysdig Secure.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class RuleFalco(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 append: Optional[pulumi.Input[bool]] = None,
                 condition: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 exceptions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleFalcoExceptionArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        ## Import

        Secure Falco runtime rules can be imported using the ID, e.g.

        ```sh
         $ pulumi import sysdig:Secure/ruleFalco:RuleFalco example 12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] append: This indicates that the rule being created appends the condition to an existing Sysdig-provided rule. By default this is false. Appending to user-created rules is not supported by the API.
        :param pulumi.Input[str] condition: A [Falco condition](https://falco.org/docs/rules/) is simply a Boolean predicate on Sysdig events expressed using the Sysdig [filter syntax](http://www.sysdig.org/wiki/sysdig-user-guide/#filtering) and macro terms.
        :param pulumi.Input[str] description: The description of Secure rule. By default is empty.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleFalcoExceptionArgs']]]] exceptions: The exceptions key is a list of identifier plus list of tuples of filtercheck fields. See below for details.
        :param pulumi.Input[str] name: The name of the exception. Only used to provide a handy name, and to potentially link together values in a later rule that has `append = true`.
        :param pulumi.Input[str] output: Add additional information to each Falco notification's output. Required if append is false.
        :param pulumi.Input[str] priority: The priority of the Falco rule. It can be: "emergency", "alert", "critical", "error", "warning", "notice", "info" or "debug". By default is "warning".
        :param pulumi.Input[str] source: The source of the event. It can be either "syscall", "k8s_audit" or "aws_cloudtrail". Required if append is false.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags for this rule.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RuleFalcoArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Secure Falco runtime rules can be imported using the ID, e.g.

        ```sh
         $ pulumi import sysdig:Secure/ruleFalco:RuleFalco example 12345
        ```

        :param str resource_name: The name of the resource.
        :param RuleFalcoArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuleFalcoArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 append: Optional[pulumi.Input[bool]] = None,
                 condition: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 exceptions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleFalcoExceptionArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuleFalcoArgs.__new__(RuleFalcoArgs)

            __props__.__dict__["append"] = append
            if condition is None and not opts.urn:
                raise TypeError("Missing required property 'condition'")
            __props__.__dict__["condition"] = condition
            __props__.__dict__["description"] = description
            __props__.__dict__["exceptions"] = exceptions
            __props__.__dict__["name"] = name
            __props__.__dict__["output"] = output
            __props__.__dict__["priority"] = priority
            __props__.__dict__["source"] = source
            __props__.__dict__["tags"] = tags
            __props__.__dict__["version"] = None
        super(RuleFalco, __self__).__init__(
            'sysdig:Secure/ruleFalco:RuleFalco',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            append: Optional[pulumi.Input[bool]] = None,
            condition: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            exceptions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleFalcoExceptionArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            output: Optional[pulumi.Input[str]] = None,
            priority: Optional[pulumi.Input[str]] = None,
            source: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'RuleFalco':
        """
        Get an existing RuleFalco resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] append: This indicates that the rule being created appends the condition to an existing Sysdig-provided rule. By default this is false. Appending to user-created rules is not supported by the API.
        :param pulumi.Input[str] condition: A [Falco condition](https://falco.org/docs/rules/) is simply a Boolean predicate on Sysdig events expressed using the Sysdig [filter syntax](http://www.sysdig.org/wiki/sysdig-user-guide/#filtering) and macro terms.
        :param pulumi.Input[str] description: The description of Secure rule. By default is empty.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleFalcoExceptionArgs']]]] exceptions: The exceptions key is a list of identifier plus list of tuples of filtercheck fields. See below for details.
        :param pulumi.Input[str] name: The name of the exception. Only used to provide a handy name, and to potentially link together values in a later rule that has `append = true`.
        :param pulumi.Input[str] output: Add additional information to each Falco notification's output. Required if append is false.
        :param pulumi.Input[str] priority: The priority of the Falco rule. It can be: "emergency", "alert", "critical", "error", "warning", "notice", "info" or "debug". By default is "warning".
        :param pulumi.Input[str] source: The source of the event. It can be either "syscall", "k8s_audit" or "aws_cloudtrail". Required if append is false.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of tags for this rule.
        :param pulumi.Input[int] version: Current version of the resource in Sysdig Secure.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RuleFalcoState.__new__(_RuleFalcoState)

        __props__.__dict__["append"] = append
        __props__.__dict__["condition"] = condition
        __props__.__dict__["description"] = description
        __props__.__dict__["exceptions"] = exceptions
        __props__.__dict__["name"] = name
        __props__.__dict__["output"] = output
        __props__.__dict__["priority"] = priority
        __props__.__dict__["source"] = source
        __props__.__dict__["tags"] = tags
        __props__.__dict__["version"] = version
        return RuleFalco(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def append(self) -> pulumi.Output[Optional[bool]]:
        """
        This indicates that the rule being created appends the condition to an existing Sysdig-provided rule. By default this is false. Appending to user-created rules is not supported by the API.
        """
        return pulumi.get(self, "append")

    @property
    @pulumi.getter
    def condition(self) -> pulumi.Output[str]:
        """
        A [Falco condition](https://falco.org/docs/rules/) is simply a Boolean predicate on Sysdig events expressed using the Sysdig [filter syntax](http://www.sysdig.org/wiki/sysdig-user-guide/#filtering) and macro terms.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of Secure rule. By default is empty.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def exceptions(self) -> pulumi.Output[Optional[Sequence['outputs.RuleFalcoException']]]:
        """
        The exceptions key is a list of identifier plus list of tuples of filtercheck fields. See below for details.
        """
        return pulumi.get(self, "exceptions")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the exception. Only used to provide a handy name, and to potentially link together values in a later rule that has `append = true`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def output(self) -> pulumi.Output[Optional[str]]:
        """
        Add additional information to each Falco notification's output. Required if append is false.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[str]]:
        """
        The priority of the Falco rule. It can be: "emergency", "alert", "critical", "error", "warning", "notice", "info" or "debug". By default is "warning".
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[Optional[str]]:
        """
        The source of the event. It can be either "syscall", "k8s_audit" or "aws_cloudtrail". Required if append is false.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of tags for this rule.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        """
        Current version of the resource in Sysdig Secure.
        """
        return pulumi.get(self, "version")

