# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['VulnerabilityExceptionArgs', 'VulnerabilityException']

@pulumi.input_type
class VulnerabilityExceptionArgs:
    def __init__(__self__, *,
                 cve: pulumi.Input[str],
                 list_id: pulumi.Input[str],
                 enabled: Optional[pulumi.Input[bool]] = None,
                 expiration_date: Optional[pulumi.Input[int]] = None,
                 notes: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a VulnerabilityException resource.
        :param pulumi.Input[str] cve: The CVE ID to make an exception to.
        :param pulumi.Input[str] list_id: The ID of the Vulnerability exception list to assign this exception to.
        :param pulumi.Input[bool] enabled: If this is false, the CVE exception will be ignored, use this if you don't want to delete
               the exception. Default: true.
        :param pulumi.Input[int] expiration_date: The expiration date of the exception, useful if you want to ignore
               some vulnerability only for a period of time. The time specified is Unix timestamp,
               and must reference a date at 00:00:00 AM. See the example where the referenced date
               is the 1st of January 2025. Default: 0 (no expiration date).
        :param pulumi.Input[str] notes: Some context of why this vulnerability is being ignored.
        """
        pulumi.set(__self__, "cve", cve)
        pulumi.set(__self__, "list_id", list_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)

    @property
    @pulumi.getter
    def cve(self) -> pulumi.Input[str]:
        """
        The CVE ID to make an exception to.
        """
        return pulumi.get(self, "cve")

    @cve.setter
    def cve(self, value: pulumi.Input[str]):
        pulumi.set(self, "cve", value)

    @property
    @pulumi.getter(name="listId")
    def list_id(self) -> pulumi.Input[str]:
        """
        The ID of the Vulnerability exception list to assign this exception to.
        """
        return pulumi.get(self, "list_id")

    @list_id.setter
    def list_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "list_id", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If this is false, the CVE exception will be ignored, use this if you don't want to delete
        the exception. Default: true.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[pulumi.Input[int]]:
        """
        The expiration date of the exception, useful if you want to ignore
        some vulnerability only for a period of time. The time specified is Unix timestamp,
        and must reference a date at 00:00:00 AM. See the example where the referenced date
        is the 1st of January 2025. Default: 0 (no expiration date).
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expiration_date", value)

    @property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[str]]:
        """
        Some context of why this vulnerability is being ignored.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notes", value)


@pulumi.input_type
class _VulnerabilityExceptionState:
    def __init__(__self__, *,
                 cve: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 expiration_date: Optional[pulumi.Input[int]] = None,
                 list_id: Optional[pulumi.Input[str]] = None,
                 notes: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering VulnerabilityException resources.
        :param pulumi.Input[str] cve: The CVE ID to make an exception to.
        :param pulumi.Input[bool] enabled: If this is false, the CVE exception will be ignored, use this if you don't want to delete
               the exception. Default: true.
        :param pulumi.Input[int] expiration_date: The expiration date of the exception, useful if you want to ignore
               some vulnerability only for a period of time. The time specified is Unix timestamp,
               and must reference a date at 00:00:00 AM. See the example where the referenced date
               is the 1st of January 2025. Default: 0 (no expiration date).
        :param pulumi.Input[str] list_id: The ID of the Vulnerability exception list to assign this exception to.
        :param pulumi.Input[str] notes: Some context of why this vulnerability is being ignored.
        """
        if cve is not None:
            pulumi.set(__self__, "cve", cve)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if expiration_date is not None:
            pulumi.set(__self__, "expiration_date", expiration_date)
        if list_id is not None:
            pulumi.set(__self__, "list_id", list_id)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)

    @property
    @pulumi.getter
    def cve(self) -> Optional[pulumi.Input[str]]:
        """
        The CVE ID to make an exception to.
        """
        return pulumi.get(self, "cve")

    @cve.setter
    def cve(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cve", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If this is false, the CVE exception will be ignored, use this if you don't want to delete
        the exception. Default: true.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> Optional[pulumi.Input[int]]:
        """
        The expiration date of the exception, useful if you want to ignore
        some vulnerability only for a period of time. The time specified is Unix timestamp,
        and must reference a date at 00:00:00 AM. See the example where the referenced date
        is the 1st of January 2025. Default: 0 (no expiration date).
        """
        return pulumi.get(self, "expiration_date")

    @expiration_date.setter
    def expiration_date(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expiration_date", value)

    @property
    @pulumi.getter(name="listId")
    def list_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Vulnerability exception list to assign this exception to.
        """
        return pulumi.get(self, "list_id")

    @list_id.setter
    def list_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "list_id", value)

    @property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[str]]:
        """
        Some context of why this vulnerability is being ignored.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notes", value)


class VulnerabilityException(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cve: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 expiration_date: Optional[pulumi.Input[int]] = None,
                 list_id: Optional[pulumi.Input[str]] = None,
                 notes: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Import

        Vulnerability exception can be imported using the ID of the exception list, and the ID of the exception separated by `/`, e.g.

        ```sh
         $ pulumi import sysdig:Secure/vulnerabilityException:VulnerabilityException example vulnexception_1iTWe5s3qFivOW4jcj5X8nnG3hn/vulnexceptionitem_1n1HL7la7LyJFAzr0DEc0hVbnFU
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cve: The CVE ID to make an exception to.
        :param pulumi.Input[bool] enabled: If this is false, the CVE exception will be ignored, use this if you don't want to delete
               the exception. Default: true.
        :param pulumi.Input[int] expiration_date: The expiration date of the exception, useful if you want to ignore
               some vulnerability only for a period of time. The time specified is Unix timestamp,
               and must reference a date at 00:00:00 AM. See the example where the referenced date
               is the 1st of January 2025. Default: 0 (no expiration date).
        :param pulumi.Input[str] list_id: The ID of the Vulnerability exception list to assign this exception to.
        :param pulumi.Input[str] notes: Some context of why this vulnerability is being ignored.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VulnerabilityExceptionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Vulnerability exception can be imported using the ID of the exception list, and the ID of the exception separated by `/`, e.g.

        ```sh
         $ pulumi import sysdig:Secure/vulnerabilityException:VulnerabilityException example vulnexception_1iTWe5s3qFivOW4jcj5X8nnG3hn/vulnexceptionitem_1n1HL7la7LyJFAzr0DEc0hVbnFU
        ```

        :param str resource_name: The name of the resource.
        :param VulnerabilityExceptionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VulnerabilityExceptionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cve: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 expiration_date: Optional[pulumi.Input[int]] = None,
                 list_id: Optional[pulumi.Input[str]] = None,
                 notes: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VulnerabilityExceptionArgs.__new__(VulnerabilityExceptionArgs)

            if cve is None and not opts.urn:
                raise TypeError("Missing required property 'cve'")
            __props__.__dict__["cve"] = cve
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["expiration_date"] = expiration_date
            if list_id is None and not opts.urn:
                raise TypeError("Missing required property 'list_id'")
            __props__.__dict__["list_id"] = list_id
            __props__.__dict__["notes"] = notes
        super(VulnerabilityException, __self__).__init__(
            'sysdig:Secure/vulnerabilityException:VulnerabilityException',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cve: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            expiration_date: Optional[pulumi.Input[int]] = None,
            list_id: Optional[pulumi.Input[str]] = None,
            notes: Optional[pulumi.Input[str]] = None) -> 'VulnerabilityException':
        """
        Get an existing VulnerabilityException resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cve: The CVE ID to make an exception to.
        :param pulumi.Input[bool] enabled: If this is false, the CVE exception will be ignored, use this if you don't want to delete
               the exception. Default: true.
        :param pulumi.Input[int] expiration_date: The expiration date of the exception, useful if you want to ignore
               some vulnerability only for a period of time. The time specified is Unix timestamp,
               and must reference a date at 00:00:00 AM. See the example where the referenced date
               is the 1st of January 2025. Default: 0 (no expiration date).
        :param pulumi.Input[str] list_id: The ID of the Vulnerability exception list to assign this exception to.
        :param pulumi.Input[str] notes: Some context of why this vulnerability is being ignored.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VulnerabilityExceptionState.__new__(_VulnerabilityExceptionState)

        __props__.__dict__["cve"] = cve
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["expiration_date"] = expiration_date
        __props__.__dict__["list_id"] = list_id
        __props__.__dict__["notes"] = notes
        return VulnerabilityException(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def cve(self) -> pulumi.Output[str]:
        """
        The CVE ID to make an exception to.
        """
        return pulumi.get(self, "cve")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        If this is false, the CVE exception will be ignored, use this if you don't want to delete
        the exception. Default: true.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="expirationDate")
    def expiration_date(self) -> pulumi.Output[Optional[int]]:
        """
        The expiration date of the exception, useful if you want to ignore
        some vulnerability only for a period of time. The time specified is Unix timestamp,
        and must reference a date at 00:00:00 AM. See the example where the referenced date
        is the 1st of January 2025. Default: 0 (no expiration date).
        """
        return pulumi.get(self, "expiration_date")

    @property
    @pulumi.getter(name="listId")
    def list_id(self) -> pulumi.Output[str]:
        """
        The ID of the Vulnerability exception list to assign this exception to.
        """
        return pulumi.get(self, "list_id")

    @property
    @pulumi.getter
    def notes(self) -> pulumi.Output[Optional[str]]:
        """
        Some context of why this vulnerability is being ignored.
        """
        return pulumi.get(self, "notes")

