# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['VulnerabilityExceptionListArgs', 'VulnerabilityExceptionList']

@pulumi.input_type
class VulnerabilityExceptionListArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a VulnerabilityExceptionList resource.
        :param pulumi.Input[str] description: The description of Vulnerability Exception list.
        :param pulumi.Input[str] name: The name of the Vulnerability Exception list.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of Vulnerability Exception list.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Vulnerability Exception list.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _VulnerabilityExceptionListState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering VulnerabilityExceptionList resources.
        :param pulumi.Input[str] description: The description of Vulnerability Exception list.
        :param pulumi.Input[str] name: The name of the Vulnerability Exception list.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of Vulnerability Exception list.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Vulnerability Exception list.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


class VulnerabilityExceptionList(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Import

        Vulnerability exception lists can be imported using the ID, e.g.

        ```sh
         $ pulumi import sysdig:Secure/vulnerabilityExceptionList:VulnerabilityExceptionList example vulnexception_1iTWe5s3qFivOW4jcj5X8nnG3hn
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of Vulnerability Exception list.
        :param pulumi.Input[str] name: The name of the Vulnerability Exception list.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[VulnerabilityExceptionListArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Vulnerability exception lists can be imported using the ID, e.g.

        ```sh
         $ pulumi import sysdig:Secure/vulnerabilityExceptionList:VulnerabilityExceptionList example vulnexception_1iTWe5s3qFivOW4jcj5X8nnG3hn
        ```

        :param str resource_name: The name of the resource.
        :param VulnerabilityExceptionListArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VulnerabilityExceptionListArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VulnerabilityExceptionListArgs.__new__(VulnerabilityExceptionListArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
        super(VulnerabilityExceptionList, __self__).__init__(
            'sysdig:Secure/vulnerabilityExceptionList:VulnerabilityExceptionList',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None) -> 'VulnerabilityExceptionList':
        """
        Get an existing VulnerabilityExceptionList resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of Vulnerability Exception list.
        :param pulumi.Input[str] name: The name of the Vulnerability Exception list.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VulnerabilityExceptionListState.__new__(_VulnerabilityExceptionListState)

        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        return VulnerabilityExceptionList(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of Vulnerability Exception list.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Vulnerability Exception list.
        """
        return pulumi.get(self, "name")

