# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 email: pulumi.Input[str],
                 first_name: Optional[pulumi.Input[str]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 system_role: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[str] email: The email for the user to invite.
        :param pulumi.Input[str] first_name: The name of the user.
        :param pulumi.Input[str] last_name: The last name of the user.
        :param pulumi.Input[str] system_role: The privileges for the user. It can be either "ROLE_USER" or "ROLE_CUSTOMER".
               If set to "ROLE_CUSTOMER", the user will be known as an admin.
        """
        pulumi.set(__self__, "email", email)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if system_role is not None:
            pulumi.set(__self__, "system_role", system_role)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[str]:
        """
        The email for the user to invite.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[str]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the user.
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "first_name", value)

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[str]]:
        """
        The last name of the user.
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_name", value)

    @property
    @pulumi.getter(name="systemRole")
    def system_role(self) -> Optional[pulumi.Input[str]]:
        """
        The privileges for the user. It can be either "ROLE_USER" or "ROLE_CUSTOMER".
        If set to "ROLE_CUSTOMER", the user will be known as an admin.
        """
        return pulumi.get(self, "system_role")

    @system_role.setter
    def system_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_role", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 email: Optional[pulumi.Input[str]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 system_role: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[str] email: The email for the user to invite.
        :param pulumi.Input[str] first_name: The name of the user.
        :param pulumi.Input[str] last_name: The last name of the user.
        :param pulumi.Input[str] system_role: The privileges for the user. It can be either "ROLE_USER" or "ROLE_CUSTOMER".
               If set to "ROLE_CUSTOMER", the user will be known as an admin.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if first_name is not None:
            pulumi.set(__self__, "first_name", first_name)
        if last_name is not None:
            pulumi.set(__self__, "last_name", last_name)
        if system_role is not None:
            pulumi.set(__self__, "system_role", system_role)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        The email for the user to invite.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the user.
        """
        return pulumi.get(self, "first_name")

    @first_name.setter
    def first_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "first_name", value)

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> Optional[pulumi.Input[str]]:
        """
        The last name of the user.
        """
        return pulumi.get(self, "last_name")

    @last_name.setter
    def last_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_name", value)

    @property
    @pulumi.getter(name="systemRole")
    def system_role(self) -> Optional[pulumi.Input[str]]:
        """
        The privileges for the user. It can be either "ROLE_USER" or "ROLE_CUSTOMER".
        If set to "ROLE_CUSTOMER", the user will be known as an admin.
        """
        return pulumi.get(self, "system_role")

    @system_role.setter
    def system_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_role", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 system_role: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Import

        Sysdig users can be imported using the ID, e.g.

        ```sh
         $ pulumi import sysdig:index/user:User example 12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] email: The email for the user to invite.
        :param pulumi.Input[str] first_name: The name of the user.
        :param pulumi.Input[str] last_name: The last name of the user.
        :param pulumi.Input[str] system_role: The privileges for the user. It can be either "ROLE_USER" or "ROLE_CUSTOMER".
               If set to "ROLE_CUSTOMER", the user will be known as an admin.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Sysdig users can be imported using the ID, e.g.

        ```sh
         $ pulumi import sysdig:index/user:User example 12345
        ```

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 first_name: Optional[pulumi.Input[str]] = None,
                 last_name: Optional[pulumi.Input[str]] = None,
                 system_role: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            __props__.__dict__["first_name"] = first_name
            __props__.__dict__["last_name"] = last_name
            __props__.__dict__["system_role"] = system_role
            __props__.__dict__["version"] = None
        super(User, __self__).__init__(
            'sysdig:index/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            email: Optional[pulumi.Input[str]] = None,
            first_name: Optional[pulumi.Input[str]] = None,
            last_name: Optional[pulumi.Input[str]] = None,
            system_role: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] email: The email for the user to invite.
        :param pulumi.Input[str] first_name: The name of the user.
        :param pulumi.Input[str] last_name: The last name of the user.
        :param pulumi.Input[str] system_role: The privileges for the user. It can be either "ROLE_USER" or "ROLE_CUSTOMER".
               If set to "ROLE_CUSTOMER", the user will be known as an admin.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["email"] = email
        __props__.__dict__["first_name"] = first_name
        __props__.__dict__["last_name"] = last_name
        __props__.__dict__["system_role"] = system_role
        __props__.__dict__["version"] = version
        return User(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[str]:
        """
        The email for the user to invite.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the user.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> pulumi.Output[Optional[str]]:
        """
        The last name of the user.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter(name="systemRole")
    def system_role(self) -> pulumi.Output[Optional[str]]:
        """
        The privileges for the user. It can be either "ROLE_USER" or "ROLE_CUSTOMER".
        If set to "ROLE_CUSTOMER", the user will be known as an admin.
        """
        return pulumi.get(self, "system_role")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        return pulumi.get(self, "version")

